<?php

class CertificateAction extends CAction
{
	public function run($id)
	{
		$id = filter_var($id, FILTER_VALIDATE_INT);

		$szkolenie = SzkolenieFirmy::model()->with('idFirmy0.uzytkownicy',
			'idSzkolenia0.dziedzina', 'idFirmy0.klasa.szkola')->findByPk($id);

		if (empty($szkolenie))
			throw new CHttpException(404, 'Nie ma podanego certyfikatu.');

		switch (Yii::app()->user->role)
		{
			case 'admin': //zawsze dostęp
				break;
			case 'student': //czy uczeń jest właścicelem firmy
				$trow = true;
				$idfirmye = Yii::app()->user->id_firmy;
				if (!empty($idfirmye))
					foreach ($szkolenie->idFirmy0->uzytkownicy as $user)
						if ($user->id == Yii::app()->user->id) {
							$trow = false;
							break;
						}
				if ($trow)
					throw new CHttpException(404, 'Brak uprawnień');
				break;
			case 'teacher': //czy nauczyciel uczy klasę firmy
				$rec = AdminKlasy::model()->find('"t"."idAdmina" = :teacherId AND "t"."idKlasy" = :classId', array(
					':teacherId' => Yii::app()->user->id,
					':classId' => $szkolenie->idFirmy0->idKlasy
				));
				if (empty($rec))
					throw new CHttpException(404, 'Brak uprawnień');
				break;
			default:
				throw new CHttpException(404, 'Brak uprawnień');
		}

		require_once('tcpdf/tcpdf.php');

		$pdf = new TCPDF('L', PDF_UNIT, PDF_PAGE_FORMAT, true, 'utf-8', false);

		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor('imaginalis.pl');
		$pdf->SetTitle('Certyfikat Nr ' . $szkolenie->id);
		$pdf->SetSubject('Certyfikat dla ' . $szkolenie->idFirmy0->friendlyName
			. ' z ' . $szkolenie->idSzkolenia0->dziedzina->nazwa . ' poziom '
			. $szkolenie->idSzkolenia0->poziom);
		$pdf->SetKeywords('certyfikat, szkolenie, '
			. $szkolenie->idSzkolenia0->dziedzina->nazwa . ', '
			. $szkolenie->idFirmy0->friendlyName . ',');

		$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));

		$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

		$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
		$pdf->SetHeaderMargin(0);
		$pdf->SetFooterMargin(0);

		$pdf->setPrintFooter(false);

		$pdf->SetAutoPageBreak(FALSE);

		$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

		if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
				require_once(dirname(__FILE__).'/lang/eng.php');
				$pdf->setLanguageArray($l);
		}

		$pdf->SetFont('freeserif', '', 10);

		$pdf->AddPage();

		$pdf->Image('images/form-backgrounds/certificate/1.jpg', 0, 0, 297, 210,
			'', '', '', false, 300, '', false, false, 0);

		$pdf->writeHTML($this->getController()->renderPartial(
			'application.controllers.actions.views.certificate',
			array('szkolenie' => $szkolenie), true), true, false, true, false, '');

		$pdf->Output('Certyfikat Nr ' . $szkolenie->id . '.pdf', 'I');
	}
}
